from datetime import datetime
from typing import Optional

from common.backend.db.sql.tables_managers import GenericFeedbackSQL
from common.backend.utils.dataiku_api import dataiku_api
from common.backend.utils.sql_timing import log_query_time

COLUMNS = [
    "date",
    "user",
    "message",
    "llm"
]

FEEDBACK_DATASET_CONF_ID = "general_feedback_dataset"

class GeneralFeedbackSQL(GenericFeedbackSQL):
    def __init__(self):
        config = dataiku_api.webapp_config
        if not config.get("allow_general_feedback", False):
            return
        super().__init__(config=config,
                         columns=COLUMNS,
                         dataset_conf_id=FEEDBACK_DATASET_CONF_ID,
                         default_project_key=dataiku_api.default_project_key)
    @log_query_time
    def add_feedback(
        self,
        timestamp: datetime,
        user: str,
        message: str,
        llm_id: Optional[str] = None
    ):
        record_value = [
            timestamp,
            user,
            message,
            llm_id if llm_id is not None else ""
        ]
        self.insert_record(record_value)


feedbacks_sql_manager = GeneralFeedbackSQL()
