import { defineConfig, devices } from "@playwright/test";
import "./playwright.setup"; 
/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
import dotenv from "dotenv";
import path from "path";
dotenv.config({ path: path.resolve(__dirname, ".env") });
console.log(`Running tests with ${process.env.TEST_PARALLEL_INDEX} index`);
const workerIndex = parseInt(process.env.TEST_PARALLEL_INDEX || "0", 10);

const authFile = `playwright/.auth/user-${workerIndex}.json`;
/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
    testDir: "./tests/playwright",
    /* Run tests in files in parallel */
    fullyParallel: false,
    maxFailures: process.env.CI ? 20 : 0,
    /* Fail the build on CI if you accidentally left test.only in the source code. */
    forbidOnly: !!process.env.CI,
    /* Retry on CI only */
    retries: process.env.CI ? 1 : 0, //Only retry once as we increaded timeout for tests to 60000ms
    /* Opt out of parallel tests on CI & local. */
    workers: process.env.CI ? 5 : 1,
    globalTimeout: process.env.CI ? 45 * 60 * 1000 : 10 * 60 * 1000,
    /* timeout for each test: Until we have different llms for decision and main model, tests need more time as claude is slow and answers with longer replies so we need to increase the timeout */
    timeout: process.env.CI ? 10 * 60 * 100 : 5 * 60 * 100,
    /* Reporter to use. See https://playwright.dev/docs/test-reporters */
    reporter: "html",
    /* Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions. */
    use: {
        /* Base URL to use in actions like `await page.goto('/')`. */
        baseURL:
            process.env.STAGING === "1"
                ? process.env.E2E_AUTH_URL
                : process.env.E2E_LOCAL_AUTH_URL,

        /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
        trace: "retain-on-failure",
        screenshot: "only-on-failure",
    },
    expect: {
        toHaveScreenshot: { maxDiffPixelRatio: 0.1 },
    },
    /* Configure projects for major browsers */
    projects: [
        {
            name: "chromium",
            use: {
                ...devices["Desktop Chrome"],
                // Use prepared auth state.
                storageState: authFile,
            },
        },

        {
            name: "firefox",
            use: {
                ...devices["Desktop Firefox"],
                // Use prepared auth state.
                storageState: authFile,
            },
        },

        {
            name: "webkit",
            use: {
                ...devices["Desktop Safari"],
                // Use prepared auth state.
                storageState: authFile,
            },
        },

        /* Test against mobile viewports. */
        {
            name: "Mobile Chrome",
            use: {
                ...devices["Pixel 5"],
                // Use prepared auth state.
                storageState: authFile,
            },
        },
        {
            name: "Mobile Safari",
            use: {
                ...devices["iPhone 12"],
                // Use prepared auth state.
                storageState: authFile,
            },
        },

        /* Test against branded browsers. */
        // {
        //   name: 'Microsoft Edge',
        //   use: { ...devices['Desktop Edge'], channel: 'msedge' },
        // },
        // {
        //   name: 'Google Chrome',
        //   use: { ...devices['Desktop Chrome'], channel: 'chrome' },
        // },
    ],

    /* Run your local dev server before starting the tests */
    // webServer: {
    //   command: 'npm run start',
    //   url: 'http://127.0.0.1:3000',
    //   reuseExistingServer: !process.env.CI,
    // },
});
