from common.backend.schemas.common_schemas import (
    GeneratedMediaSchema,
    MessageFeedbackSchema,
    ProcessedFileSchema,
    RetrievalSchema,
)
from marshmallow import Schema, fields


class MessageResponseSchema(Schema):
    id = fields.String(required=True)
    createdAt = fields.String(required=True)
    query = fields.String(required=True)
    answer = fields.String(required=True)
    usedRetrieval = fields.Nested(RetrievalSchema) 
    feedback = fields.Nested(MessageFeedbackSchema)
    files = fields.List(fields.Nested(ProcessedFileSchema))
    generatedMedia = fields.List(fields.Nested(GeneratedMediaSchema))