import base64
import re


def convert_font_to_base64(font_folder_path, fonts_library, font_face_css):
    # Regex to find the URL and format within the @font-face rule
    font_url_pattern = re.compile(r"url\(['\"]?(.+?)['\"]?\)\s*format\(['\"]?(.+?)['\"]?\)")
    
    # Function to encode font to base64
    def encode_font_to_base64(font_path, font_format):
        font_file = fonts_library.get_folder(font_folder_path).get_file(font_path)
        if font_file:
            font_data = font_file.read().encode('utf-8')
            font_base64 = base64.b64encode(font_data).decode('utf-8')
            return f"url(data:font/{font_format};base64,{font_base64}) format('{font_format}')"
    
    def replacement(match):
        font_path = match.group(1)
        font_format = match.group(2)
        # Check if the font_path is already a base64 data URI
        base64_pattern = re.compile(r"data:font/[^;]+;base64,.+")
        if not font_path.startswith('http') and not base64_pattern.match(font_path):
            # Encode the font file to base64
            base64_font = encode_font_to_base64(font_path, font_format)
            # Replace the original URL with base64 encoded data
            return base64_font
        else:
            # If the font URL starts with http, leave it as is
            return f"url('{font_path}') format('{font_format}')"
    
    # Replace all URLs in the font_face_css string using the replacement function
    new_font_face_css = re.sub(font_url_pattern, replacement, font_face_css)
    
    return new_font_face_css
