import time

from common.llm_assist.logging import logger

# TODO: This file and its location probably need to change if they are logging llm too

def log_execution_time(func):
    def wrapper(*args, **kwargs):
        start_time = time.time()

        class_name = None
        if args:
            instance = args[0]
            if hasattr(instance, "__class__"):
                if hasattr(instance.__class__, func.__name__):
                    class_name = instance.__class__.__name__

        func_label = f"{class_name}.{func.__name__}" if class_name else func.__name__
        logger.info(f"(START '{func_label}')")

        result = func(*args, **kwargs)

        end_time = time.time()
        execution_time = round(end_time - start_time, 3)
        logger.info(f"(END '{func_label}') Took {execution_time}s to run")

        return result
    return wrapper