
import unittest
from unittest.mock import MagicMock, patch

from common.backend.models.base import MediaSummary
from common.backend.utils.upload_utils import save_extracted_json


class TestUploadUtils(unittest.TestCase):

    @patch("common.backend.utils.upload_utils.dataiku_api")
    def test_save_extracted_json(self, mock_dataiku_api):
        # Define multiple test cases with tuples of (file_path, expected_metadata_path)
        test_cases = [
            ("user/1745422445_my_file.pdf", "user/1745422445_my_file_extracted_text.json"),
            ("user/1745422445_my.file.pdf", "user/1745422445_my.file_extracted_text.json"),
            ("user/1234567890_another.file.doc", "user/1234567890_another.file_extracted_text.json"),
            ("user.name/1745422445_my_file.pdf", "user.name/1745422445_my_file_extracted_text.json"),
            ("user.name/1234567890_another.file.doc", "user.name/1234567890_another.file_extracted_text.json"),
            ("user/1234567890_duplicate.doc", "user/1234567890_duplicate_extracted_text1.json"),
        ]
        for file_path, expected_metadata_path in test_cases:
            with self.subTest(file_path=file_path, expected_metadata_path=expected_metadata_path):
                # Arrange
                media_sum = MediaSummary(
                    original_file_name="dummy_name", 
                    file_path=file_path,
                    metadata_path=''
                )

                mock_folder_handle = MagicMock()
                mock_folder_handle.list_paths_in_partition.return_value = [
                    "/user/1234567890_duplicate_extracted_text.json"
                ]

                mock_dataiku_api.folder_handle = mock_folder_handle


                # Act
                save_extracted_json(file_path, media_sum)

                # Assert
                mock_dataiku_api.folder_handle.write_json.assert_called_once()
                mock_dataiku_api.folder_handle.write_json.assert_called_once_with(
                    expected_metadata_path, media_sum
                )