from common.backend.routes.ui_settings import settings_bp
from flask import Blueprint

from .config import config_blueprint
from .conversation import conversation_blueprint
from .feedback import general_feedback_blueprint
from .file import file_blueprint

api = Blueprint("api", __name__, url_prefix="/api")
api.register_blueprint(file_blueprint)
api.register_blueprint(conversation_blueprint)
api.register_blueprint(config_blueprint)
api.register_blueprint(general_feedback_blueprint)
api.register_blueprint(settings_bp)
