import pytest
from common.backend.utils.metas_utils import convert_to_list, is_string_list_representation


@pytest.mark.parametrize("test_input,expected", [("string", "string"), ("[1, 2]", [1, 2])])
def test_convert_to_list(test_input, expected):
    assert convert_to_list(test_input) == expected


@pytest.mark.parametrize("test_input,expected", [("string", False), (1, False), ("[]", True)])
def test_is_string_list_representation(test_input, expected):
    assert is_string_list_representation(test_input) == expected
