from typing import Any, Dict, List, Optional, TypedDict

from common.backend.models.base import (
    ConversationParams,
    ExtractedQueryInfo,
    LLMContext,
    MediaSummary,
    QuestionData,
)
from common.backend.models.source import RAGImage, Source


class AnswersInfo(TypedDict):
    project_key: str
    webapp_name: str
    webapp_id: str
    webapp_description: str
    webapp_running: str


class AgentDetails(TypedDict):
    agent_id: str
    name: str
    description: Optional[str]
    project_key: Optional[str] #for now useful for agents only


class AgentQuery(TypedDict):
    query: str
    agent_id: str


class AgentGeneratedAnswer(TypedDict, total=False):
    sub_query: str
    agent_answer: str
    agent_id: str
    agent_name: str
    sources: List[Any]
    used_tool: Optional[Dict[str, Any]]


class PortalExtractedQueryInfo(ExtractedQueryInfo, total=False):
    agents_files_uploads: Optional[Dict[str, Dict[str, MediaSummary]]]


class AgentsSelection(TypedDict):
    calls: List[AgentQuery]
    justification: str


class PortalLLMContext(LLMContext, total=False):
    agents_files_uploads: Optional[Dict[str, Dict[str, MediaSummary]]]
    agents_selection: Optional[AgentsSelection]


class PortalConversationParams(ConversationParams, total=False):
    sources: Optional[List[Source]]
    agents_files_uploads: Optional[
        Dict[str, Dict[str, MediaSummary]]
    ]  # Dict[original_file_name, Dict[project_key,agent_media_summary]]


class PortalQuestionData(QuestionData):
    agents_files_uploads: Optional[Dict[str, MediaSummary]]
    agents_selection: Optional[AgentsSelection]


class SourceItem(TypedDict, total=False):
    type: str
    metadata: Dict[str, str]
    title: str
    url: str
    textSnippet: str
    records: Any
    images: List[RAGImage]


class ToolCall(TypedDict, total=False):
    toolCallDescription: str
    items: List[SourceItem]


class PortalSource(TypedDict, total=False):
    name: str
    id: str
    type: str
    items: List[ToolCall]
    # used to store agent answer, useful for debugging and understanding how the final answer was generated.
    answer: Optional[str]
