
from typing import Any, Dict, List, Optional, TypedDict, Union


class RAGImage(TypedDict, total=False):
    full_folder_id: str
    file_path: str
    index: int
    file_data: str

# New in DSS 14
class SourceRecords(TypedDict, total=False):
    columns: Optional[List[str]]
    data: Optional[List[List[Dict]]]


# New in DSS 14
class ImageRef(TypedDict, total=False):
    folderId: Optional[str]
    path: Optional[str]


# New in DSS 14
class DocumentPageRange(TypedDict, total=False):
    start: Optional[int]
    end: Optional[int]

# New in DSS 14
class FileRef(TypedDict, total=False):
    folderId: Optional[str]
    path: Optional[str]
    pageRange: Optional[DocumentPageRange]


class Source(TypedDict, total=False):
    # We have similarities with DSS sources but we also have some 
    # specific things related to the way we build Sources

    # Standard types
    # - FILE_BASED_DOCUMENT: means there will be a fileRef with the path of the reference document
    # - SIMPLE_DOCUMENT:     will still be used if the informations comes from a dataset embed recipe and 
    #                        there's no specific document as source
    # - RECORDS
    type: Optional[str] # new type FILE_BASED_DOCUMENT

    # Generic usage
    metadata: Optional[Dict[str, Union[str, int, float, List[Any]]]]
    performedQuery: Optional[str]
    
    # For RECORDS
    records: Optional[SourceRecords]
    
    # For FILE_BASED_DOCUMENT
    fileRef: Optional[FileRef]          # new in DSS 14
    imageRefs: Optional[List[ImageRef]] # new in DSS 14
    
    # For SIMPLE_DOCUMENT
    title: Optional[str]
    url: Optional[str]
    thumbnailInlineB64: Optional[str]   # new in DSS 14
    thumbnailURL: Optional[str]         # new in DSS 14
    thumbnailW: Optional[int]           # new in DSS 14
    thumbnailH: Optional[int]           # new in DSS 14

    # For SIMPLE_DOCUMENT and FILE_BASED_DOCUMENT
    textSnippet: Optional[str] 
    markdownSnippet: Optional[str]      # new - to handle in front
    htmlSnippet: Optional[str]          # new - to handle in front

    # Genai specific, not in dip sources  
    excerpt: Optional[str]
    sample: Optional[Dict[str, Union[str, int, float]]]
    images: Optional[List[RAGImage]]
    usedTables: Optional[str]
    tool_name_used: Optional[str]
    generatedSqlQuery: Optional[str] 


# if you update it think to common.backend.schemas.common_schemas.py::SourceSchema
# but be careful with what should be reflected in the API and what not
class AggregatedToolSources(TypedDict, total=False):
    toolCallDescription: Optional[str]
    items: Optional[List[Source]]