from marshmallow import Schema, fields


class UISettingsSchema(Schema):
    language = fields.String(required=True)
    theme = fields.String(required=True)
    logoFileName = fields.String(required=True)
    iconFileName = fields.String(required=True)
    inputPlaceholder = fields.String(required=True)
    fontSize = fields.String(required=True)

class APIResponseSchema(Schema):
    status = fields.String(required=True)
    data = fields.Nested(
        {"uiSettings": fields.Nested(UISettingsSchema)},
        required=True
    )