import ast
from enum import Enum
from typing import Type, Union

from common.llm_assist.logging import logger


def is_string_list_representation(string):
    try:
        _ = ast.literal_eval(string)
        return isinstance(_, list)
    except:
        return False

def convert_to_list(string):
    try:
        return ast.literal_eval(string)
    except:
        return string 


def is_valid_enum_value(value: Union[str, Enum], enum_reference: Type[Enum])->bool:
    if isinstance(value, enum_reference):
        return True
    try:
        enum_reference(value)
        return True
    except Exception as e:
        logger.debug(f"Exception met when checking validity of '{value}' as part of '{enum_reference}': {e}")
        return False