import logging

from common.backend.utils.dataiku_api import dataiku_api
from flask import Flask
from flask_socketio import SocketIO
from portal.backend.routes import setup_socketio_answer_event_handlers
from portal.backend.utils.version import log_current_version


class NoParsingFilter(logging.Filter):
    def filter(self, record):
        message = record.getMessage()            
        return not message.endswith('AssertionError: write() before start_response')


def setup_app(app: Flask):
    # Prevent Assertion error logging from Werkeug
    logging.getLogger("werkzeug").addFilter(NoParsingFilter())
    # Handle WebSockets for streaming
    socketio = SocketIO(app, cors_allowed_origins='*', path="/stream")
    setup_socketio_answer_event_handlers(socketio)

    log_current_version()

    @app.after_request
    def apply_security_headers(response):
        return setup_headers(response)
    return socketio

def setup_headers(response):
    config = dataiku_api.webapp_config
    http_headers = config.get("http_headers", [])
    for header in http_headers:
        response.headers[header["from"]] = header["to"]
    return response
