import { ref } from 'vue'

import { useLocalStorage } from './useLocalStorage'

import type { FilterConfig, RetrieverInfo } from '@/models'

const { data: filtersSelections } = useLocalStorage<Record<string, any[]>>(
  `selected-filters`,
  {}
)
const { data: knowledgeBankSelection } = useLocalStorage<string>(
  'selected-knowledge-bank',
  null
)
const { data: retrieverSelected } = useLocalStorage<boolean>(
  'retriever-selected',
  false
)
const { data: dbSelection } = useLocalStorage<string>(
  'sql-retrieval-table',
  null
)
const userSettings = ref<Record<string, any>>({})

export function useSettings() {
  function updateDbSettings(dbRetriever: RetrieverInfo | null) {
    dbSelection.value = dbRetriever?.id ?? null
    retrieverSelected.value = dbSelection.value ? true : false
  }
  function updateKbSettings(
    knowledgeBank?: RetrieverInfo | null,
    filtersConfig?: FilterConfig | null
  ) {
    if (
      !knowledgeBank ||
      (knowledgeBankSelection.value &&
        knowledgeBank.id !== knowledgeBankSelection.value)
    ) {
      //Knowledge bank has changed we delete previously saved selection of filters and knowledge bank
      filtersSelections.value = null
      knowledgeBankSelection.value = null
    } else if (filtersSelections.value && filtersConfig) {
      let shouldBreak = false
      for (const key of Object.keys(filtersSelections.value)) {
        if (!filtersConfig.filter_columns.includes(key)) {
          // Filter has changed, delete previously saved selections
          filtersSelections.value = {}
          shouldBreak = true // Set flag to break the outer loop
          break
        } else {
          for (const op of filtersSelections.value[key]) {
            if (!filtersConfig.filter_options[key].includes(op)) {
              // Filter has changed, delete previously saved selections
              filtersSelections.value = {}
              shouldBreak = true // Set flag to break the outer loop
              break
            }
          }
          if (shouldBreak) break // Break the outer loop if needed
        }
      }
    }
    retrieverSelected.value = knowledgeBankSelection.value ? true : false
  }
  function updateUserSettingsMediaInfo(userProfile: any) {
    // update user profile media info
    userSettings.value['generated_media_info'] =
      userProfile['generated_media_info']
  }
  return {
    filtersSelections,
    knowledgeBankSelection,
    dbSelection,
    retrieverSelected,
    updateDbSettings,
    updateKbSettings,
    userSettings,
    updateUserSettingsMediaInfo
  }
}
