from common.backend.schemas.messages import MessageResponseSchema
from marshmallow import Schema, fields


class ApplicationContextSchema(Schema):
    applicationId = fields.String(required=True)


class ConversationTitleSchema(Schema):
    original = fields.Str(required=True)
    edited = fields.Str(required=False)
    createdAt = fields.String(required=False)


class ConversationMetadataSchema(Schema):
    id = fields.String(required=True)
    title = fields.Nested(ConversationTitleSchema, required=False)
    createdAt = fields.String(required=True)
    lastMessageAt = fields.String(required=True)
    state = fields.String(required=True)


class ConversationsResponseSchema(Schema):
    user = fields.String(required=True)
    context = fields.Nested(ApplicationContextSchema, required=True) # type: ignore
    conversations = fields.List(fields.Nested(ConversationMetadataSchema), required=True)


class SingleConversationResponseSchema(ConversationMetadataSchema):
    user = fields.String(required=True)
    context = fields.Nested(ApplicationContextSchema, required=True) # type: ignore
    messages = fields.List(fields.Nested(MessageResponseSchema), required=True)
    state = fields.String(required=True)