import { computed, onMounted } from 'vue'
import { useAgentCatalogStore } from '@/store/agentCatalogStore'
import { useAgentStore } from '@/store/agentStore'

export function useAgents() {
  const store = useAgentCatalogStore()
  onMounted(() => store.load())

  return {
    agents: computed(() => store.agents),
    activeAgents: computed(() => store.activeAgents),
    agentsById: computed(() => {
      const m = new Map<string, any>()
      store.agents.forEach((a) => m.set(a.id, a))
      return m
    }),
    loading: computed(() => store.loading),
    fetchAgents: (force = false) => store.load(force),
  }
}

export function isAgentActive(id: string, agents: any[]): boolean {
  if (agents.some((a) => a.id === id && a.status !== 'draft')) return true
  const draft = agents.find((a) => a.id === id && a.status === 'draft')
  return !!draft?.published_version
}

export function isAgentDeleted(id: string, agents: any[]): boolean {
  const agentStore = useAgentStore()
  if (id === agentStore.draft.id) {
    return false
  }
  return !agents.find((a) => a.id === id)
}
