import { defineStore } from 'pinia'
import { ref } from 'vue'

export const useApiErrorStore = defineStore('apiError', () => {
  const errors = ref<any[]>([])

  function addError(error: any) {
    errors.value.push(error)
  }

  function clearErrors() {
    errors.value = []
  }

  return { errors, addError, clearErrors }
})
