import { defineStore } from 'pinia'
import { ref } from 'vue'

export const useChatStore = defineStore('chat', () => {
  const conversationId = ref<string | null>(null)
  const agentIds = ref<string[]>([])
  const messages = ref<any[]>([])

  function setConversation(newId: string | null, newAgents: string[] = []) {
    conversationId.value = newId
    agentIds.value = newAgents
  }

  function updateAgents(newAgents: string[]) {
    agentIds.value = [...newAgents]
  }

  function clearConversation() {
    conversationId.value = null
    agentIds.value = []
    messages.value = []
  }

  function setMessages(newMessages: any[]) {
    messages.value = newMessages
  }

  return {
    conversationId,
    agentIds,
    messages,
    setConversation,
    updateAgents,
    clearConversation,
    setMessages,
  }
})
