import re


def extract_json_string(raw):
    m = re.search(r"```json\s*(\{[\s\S]*?\})\s*```", raw, re.IGNORECASE)
    if m:
        candidate = m.group(1)
    else:
        start, end = raw.find("{"), raw.rfind("}")
        candidate = raw[start : end + 1] if start != -1 < end else raw

    return candidate
