"""add merged_context column to messages

Revision ID: 2368ae4f97cc
Revises: 53647ca7796d
Create Date: 2026-02-09 09:56:15.656541

"""
import os
import sys
from typing import Sequence, Union

import sqlalchemy as sa

# Add alembic folder to path for utils import
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from utils import (
    JsonEncoded,
    batch_alter_table,
)

# revision identifiers, used by Alembic.
revision: str = '2368ae4f97cc'
down_revision: Union[str, Sequence[str], None] = '53647ca7796d'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    """Upgrade schema."""
    with batch_alter_table("messages") as batch_op:
        batch_op.add_column(sa.Column("merged_context", JsonEncoded(), nullable=True, server_default=sa.text("'{}'")))


def downgrade() -> None:
    """Downgrade schema."""
    with batch_alter_table("messages") as batch_op:
        batch_op.drop_column("merged_context")
