"""add memory and tool validation to messages
Revision ID: 53647ca7796d
Revises: 43647ca7796c
Create Date: 2026-01-27 10:00:00.000000
"""
import os
import sys
from typing import Sequence, Union

import sqlalchemy as sa

# Add alembic folder to path for utils import
sys.path.insert(0, os.path.dirname(os.path.dirname(os.path.abspath(__file__))))
from utils import (
    JsonEncoded,
    batch_alter_table,
)

# revision identifiers, used by Alembic.
revision: str = '53647ca7796d'
down_revision: Union[str, None] = '43647ca7796c'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None

def upgrade() -> None:
    """Upgrade schema."""
    with batch_alter_table("messages") as batch_op:
        batch_op.add_column(sa.Column("memory_fragment", JsonEncoded(), nullable=True))
        batch_op.add_column(sa.Column("tool_validation_requests", JsonEncoded(), nullable=True))
        batch_op.add_column(sa.Column("tool_validation_responses", JsonEncoded(), nullable=True))

def downgrade() -> None:
    """Downgrade schema."""
    with batch_alter_table("messages") as batch_op:
        batch_op.drop_column("memory_fragment")
        batch_op.drop_column("tool_validation_requests")
        batch_op.drop_column("tool_validation_responses")
