#!/bin/bash
set -e

PATCH_FILE="dev.patch"

if [ ! -f "$PATCH_FILE" ]; then
  echo "dev.patch not found."
  exit 0
fi

# reverse apply
# 1) see if we can reverse-apply to the *working tree*
if git apply -R --check "$PATCH_FILE" >/dev/null 2>&1; then
  git apply -R "$PATCH_FILE"
  echo "✅ dev patch removed from working tree."
  exit 0
fi

# 2) if we got here, reverse failed (most likely: file changed since patch was made)
echo "❌ Could not reverse dev.patch cleanly."
echo "This usually means you edited the same files after creating/applying the patch."
echo