"""
Parameter provider for Agent Hub Table connector.

Delegates to shared params_helpers module for dynamic choices.
"""

from backend.params_helpers import get_project_choices, get_table_choices, get_webapp_choices


def do(payload, config, plugin_config, inputs):
    """Main entry point for connector parameter choices."""
    param_name = payload.get("parameterName")

    if param_name == "project_key":
        return get_project_choices()
    elif param_name == "webapp_id":
        return get_webapp_choices(config)
    elif param_name == "table_name":
        return get_table_choices(config)

    return {"choices": []}
