from typing import Optional, Protocol, runtime_checkable

from backend.schemas import schemas


@runtime_checkable
class IUserStore(Protocol):
    def get_agent(self, agent_id: str) -> Optional[schemas.AgentRead]: ...
    def get_all_agents(self, all_users: bool = False) -> list[schemas.AgentRead]: ...
    def create_agent(self, agent_dict) -> schemas.AgentRead: ...
    def update_agent(self, agent_id, update_data, bypass_user=False) -> Optional[schemas.AgentRead]: ...
    def delete_agent(self, agent_id) -> bool: ...
    def get_agent_shares(self, agent_id: str) -> list[schemas.AgentShareRead]: ...
    def get_agents_shared_with(self) -> list[schemas.AgentRead]: ...
    def get_share_counts(self, agent_ids: list[str]) -> dict[str, int]: ...
    def get_conversations(self) -> list[schemas.FullConversationRead]: ...
    def get_conversations_ids(self) -> list[str]: ...
    def get_conversations_metadata(self) -> list[schemas.ConversationMetadata]: ...
    def update_conversation(self, conversation_id, conversation_obj) -> Optional[schemas.ConversationUpdate]: ...
    def delete_conversation(self, conversation_id, permanent_delete: bool = False) -> bool: ...
    def get_conversation(self, conversation_id: str) -> Optional[schemas.FullConversationRead]: ...
    def create_conversation(self, conv_id: str, new_conv: schemas.ConversationCreate) -> schemas.ConversationRead: ...
    def ensure_conversation_exists(
        self, conv_id: str, agent_ids: list[str], mode_agents: bool = True, llm_id: Optional[str] = None
    ) -> schemas.FullConversationRead: ...
    def append_message(self, conversation_id: str, message: dict) -> None: ...
    def get_message(self, message_id) -> Optional[schemas.MessageRead]: ...
    def get_message_artifacts_meta(self, message_id) -> Optional[schemas.ArtifactsMetadata]: ...
    def update_message(self, message_id: str, updates: dict) -> None: ...
    def update_message_feedback(self, message_id: str, rating: int | None, text: str | None) -> None: ...
    def clear_message_feedback(self, message_id: str) -> None: ...
    def append_messages(self, conversation_id: str, messages: list[dict]) -> None: ...
    def update_conversation_meta(
        self,
        conversation_id: str,
        *,
        title=None,
        agent_ids=None,
        agents_enabled: Optional[bool] = None,
        llm_id: Optional[str] = None,
    ) -> None: ...
    def get_message_events(self, message_id: str) -> list[dict]: ...
    def get_preferences(self) -> Optional[schemas.PreferenceRead]: ...
    def update_preferences(self, prefs: dict) -> Optional[schemas.PreferenceRead]: ...
    def get_draft_conversation(self, agent_id: str) -> Optional[schemas.DraftConversationRead]: ...
    def upsert_draft_conversation(self, agent_id: str, convo: dict) -> None: ...
    def delete_draft_conversation(self, agent_id: str) -> None: ...
    def agent_exists(self, agent_id: str) -> bool: ...
    def delete_message(self, message_id: str) -> bool: ...
    def list_user_agent_owners(self) -> list[dict]: ...
    def get_message_trace(self, message_id: str) -> Optional[str]: ...
    def insert_or_update_message_attachments(self, message_id: str, attachments_json: str) -> None: ...
    def get_derived_documents(self, conv_id: str) -> list[schemas.DerivedDocument]: ...
    def upsert_derived_document(
        self, conv_id: str, document_name: str, document_path: str, metadata: Optional[dict] = None
    ) -> schemas.DerivedDocument: ...
    def delete_derived_document_by_source_path(self, document_path: str) -> bool: ...
