from flask import Blueprint

from backend.routes.admin import admin_bp
from backend.routes.app_config import config_bp
from backend.routes.charts import chart_bp
from backend.routes.conversations import convs_blueprint
from backend.routes.dashboard import dashboard_bp
from backend.routes.downloads import downloads_bp
from backend.routes.prompts import prompts_bp
from backend.routes.stories import stories_blueprint
from backend.routes.user import users_bp

api = Blueprint("api", __name__, url_prefix="/api")
api.register_blueprint(stories_blueprint)
api.register_blueprint(convs_blueprint)
api.register_blueprint(chart_bp)
api.register_blueprint(config_bp)
api.register_blueprint(dashboard_bp)
api.register_blueprint(users_bp)
api.register_blueprint(downloads_bp)
api.register_blueprint(admin_bp)
api.register_blueprint(prompts_bp)
