from flask import Blueprint, jsonify, request

from backend.config import get_ui_config
from backend.services.smart_config_service import SmartConfigService
from backend.utils.logger_utils import log_http_request
from backend.utils.logging_utils import get_logger
from backend.utils.utils import (
    get_store,
    get_user_base_llm,
)

logger = get_logger(__name__)

config_bp = Blueprint("config", __name__, url_prefix="/config")


@config_bp.route("", methods=["GET"])
@log_http_request
def get_webapp_config():
    return jsonify(get_ui_config()), 200


@config_bp.route("/smart_agent_details", methods=["POST"])
@log_http_request
def generate_quick_agent_details():
    settings = request.get_json()
    store = get_store()
    llm_id = get_user_base_llm(store)
    try:
        # -------- retrieve info from request  -------------------------
        agent_name = settings["agent_name"]
        description = settings.get("description", "")
        system_prompt = settings.get("system_prompt", "")
        rep = SmartConfigService.generate_quick_agent_config(
            agent_name=agent_name,
            description=description,
            system_prompt=system_prompt,
            llm_id=llm_id,
        )
        return jsonify(rep), 200
    except Exception as e:
        logger.exception(f"Error generating quick agent details {e}")
    return jsonify({"error": "Failed to generate agent details"}), 500
