from typing import Dict, Generator, List

from backend.database.crud import export_data as export_crud


class ExportService:
    """
    Service layer for exporting database tables.
    Delegates to CRUD operations in backend.database.crud.export
    """
    def __init__(self, db_url: str = None, workload_folder_path: str = None):
        self.db_url = db_url
        self.workload_folder_path = workload_folder_path
        pass

    # ============================================================================
    # Export methods for DSS Recipe
    # ============================================================================

    def list_exportable_tables(self) -> List[str]:
        """
        List all tables available for export.

        Returns:
            List of table names in the database (excluding system/internal tables)
        """
        return export_crud.list_exportable_tables()

    def get_table_schema(self, table: str) -> List[Dict[str, str]]:
        """
        Get schema information for a table.

        Args:
            table: Table name

        Returns:
            List of column definitions with name and type
        """
        return export_crud.get_table_schema(table)

    def export_table_rows(self, table: str, decompress: bool = True) -> Generator[Dict, None, None]:
        """
        Export all rows from a table.

        Args:
            table: Table name
            decompress: Whether to decompress BLOB data (for messages table)

        Yields:
            Dictionary for each row
        """
        return export_crud.export_table_rows(self.db_url, self.workload_folder_path, table, decompress)