LLM_ID = "openai:bs-openai:gpt-4o"
DB_FOLDER_PATH = ""

DEFAULT_CONFIG = {
    "LLMs": [
        {"$$hashKey": "object:287", "llm_id": LLM_ID},
    ],
    "tool_agent_configurations": [],
    "orchestration_mode": "manual",
    "logLevel": "INFO",
    "projects_keys": [],
    "agents_ids": [],
    "tools": [],
    "db_folder_path": DB_FOLDER_PATH,
    "default_fs_connection": "filesystem_managed",
}
def update(original, updates):
    # Update the default config with local config
    for key, value in updates.items():
        if isinstance(original.get(key), list) and isinstance(value, list):
            original[key] = value
        elif isinstance(original.get(key), dict) and isinstance(value, dict):
            original[key].update(value)
        else:
            original[key] = value
    return original

def load_local_config():
    import json
    import locale
    from pathlib import Path
    print("ATTENTION: Loading local configuration...")
    local_config_path = Path(__file__).parent.parent / "local_config.json"
    config = DEFAULT_CONFIG.copy()
    # Override with local configuration if it exists
    if local_config_path.exists():
        with open(local_config_path, "r", encoding=locale.getpreferredencoding(False)) as local_config_file:
            local_config = json.load(local_config_file)
            # Update the default config with local config
            update(config, local_config)
            # config.update(local_config)
    else:
        print(
            "No local configuration found. Default configuration will be used. Create a local_config.json file to override it."
        )
    return config

