import * as echarts from 'echarts/core'
import {
  LineChart as ELineChart,
  PieChart as EPieChart,
  BarChart as EBarChart,
  HeatmapChart as EHeatmapChart,
} from 'echarts/charts'
import {
  TitleComponent,
  TooltipComponent,
  LegendComponent,
  GridComponent,
  VisualMapComponent,
  ToolboxComponent,
  DataZoomComponent,
  MarkLineComponent,
  DatasetComponent,
} from 'echarts/components'
import { CanvasRenderer } from 'echarts/renderers'

echarts.use([
  // charts
  ELineChart,
  EBarChart,
  EHeatmapChart,
  EPieChart,
  // components
  TitleComponent,
  TooltipComponent,
  LegendComponent,
  GridComponent,
  VisualMapComponent,
  ToolboxComponent,
  DataZoomComponent,
  MarkLineComponent,
  // renderer
  CanvasRenderer,
  DatasetComponent,
])

export { echarts }
