export type IconSize = 12 | 16 | 20 | 24 | 32 | 48

export function getAttachmentIcon(documentName: string, size: IconSize = 16): string {
  const extension = documentName.split('.').pop()?.toLowerCase()

  switch (extension) {
    case 'pdf':
      return `dku-icon-file-pdf-${size}`
    case 'pptx':
      return `dku-icon-file-ppt-${size}`
    case 'png':
    case 'jpg':
    case 'jpeg':
      return `dku-icon-image-${size}`
    case 'csv':
      return `dku-icon-table-${size}`
    case 'html':
      return `dku-icon-code-${size}`
    case 'docx':
    case 'doc':
    case 'txt':
    case 'md':
      return `dku-icon-file-text-${size}`
    default:
      return `dku-icon-file-${size}`
  }
}
