export const MOCKED_TOOL_REQUESTS = [
  {
    id: 'validation-fc_0005f7f4ae4c41ed01696fbcc594d08192bf984a56db5933bf',
    hierarchy: [
      {
        type: 'AGENT',
        agentId: 'fn8RV8jC',
        agentName: 'genai trends expert',
        agentLoopIteration: 1,
      },
    ],
    message: `You're about to call the hashing tool to compute the hash of the following payload:\n##### Payload of the tool call\n<pre><code>{"payload": "29192c62eeb9024d2a01c139e80107155fd333e9"}</code></pre> Do you want to proceed?`,
    allowEditingInputs: false,
    toolName: 'Query another agent or an LLM',
    toolInputSchema: {
      $schema: 'https://json-schema.org/draft/2020-12/schema',
      $id: 'https://dataiku.com/agents/tools/llm-mesh/llm/query',
      title: 'Query an LLM using the LLM Mesh',
      type: 'object',
      properties: {
        question: {
          type: 'string',
          description: 'the question to ask',
        },
      },
    },
    toolCall: {
      type: 'function',
      function: {
        name: 'Query_another_agent_or_an_LLM__dcbc43',
        arguments: JSON.stringify({
          question: 'What are the latest generative AI trends?',
          context: {
            industry: 'Technology',
            focus_areas: ['Machine Learning', 'NLP', 'Computer Vision'],
            time_period: '2024-2026',
          },
          filters: {
            min_relevance: 0.8,
            max_results: 10,
            include_sources: true,
            categories: ['research', 'applications', 'tools'],
          },
          output_config: {
            format: 'markdown',
            include_citations: true,
            summary_length: 'detailed',
            metadata: {
              requested_by: 'user123',
              timestamp: '2026-02-03T10:30:00Z',
              priority: 'high',
            },
          },
          tags: ['AI', 'trends', 'analysis'],
          enabled: true,
          max_tokens: 2000,
        }),
      },
      id: 'fc_0005f7f4ae4c41ed01696fbcc594d08192bf984a56db5933bf',
      index: 1,
    },
  },
]
