import type { ToolValidationResponse } from '@/types/messages'

/**
 * Find a tool validation response by request ID
 */
export function findToolValidationResponse(
  responses: ToolValidationResponse[] | undefined,
  requestId: string | number
): ToolValidationResponse | undefined {
  return responses?.find((res) => res.validationRequestId === requestId)
}

/**
 * Get the appropriate icon class for tool validation events based on their status
 */
export function getToolValidationIcon(): string {
  return 'dku-icon-bell-16'
}
