import { isLocal } from '@/lib/utils'
import { defineStore } from 'pinia'
import { computed, ref } from 'vue'
import { UserProfiles } from '@/constants/user'

const localUserProfile = import.meta.env.VITE_USER_PROFILE

export const useUserStore = defineStore('user', () => {
  const userProfile = ref<UserProfiles | null>(null)
  const fetchUserProfile = async () => {
    try {
      if (isLocal()) {
        console.log('Local DEV', localUserProfile)
        userProfile.value = localUserProfile
        return
      }
      const reportingUtils = (window as any).dkuUsageReportingUtils
      await reportingUtils.standaloneModeBootstrap()
      userProfile.value = reportingUtils.getAppConfig().userProfile.profile
      console.info('User profile ' + userProfile.value)
    } catch {
      console.error('Failed to retrieve user profile')
    }
  }
  const userHasFullAccess = computed(
    () =>
      userProfile.value &&
      userProfile.value !== UserProfiles.AIAccessUser &&
      userProfile.value !== UserProfiles.Reader
  )

  const hasUserBeenSet = computed(() => {
    return userProfile.value !== null
  })
  return { userProfile, fetchUserProfile, userHasFullAccess, hasUserBeenSet }
})
