export type ChartKind = 'line' | 'pie'

export type LineChartInput = {
  kind: 'line'
  title?: string
  x: string[] // categories along the x-axis
  series: Array<{
    name: string
    data: number[] // same length as x
  }>
  yUnit?: string // e.g., "€", "ms", "%"
  smooth?: boolean // line smoothing
  stacked?: boolean // stack multiple series
  xIsDate?: boolean
  xLabelRotate?: number
}

export type PieChartInput = {
  kind: 'pie'
  title?: string
  series: Array<{
    name: string // label
    value: number
  }>
  donut?: boolean // true to display as donut
}
export type BarChartInput = {
  kind: 'bar'
  title?: string
  x: string[] // categories along x
  series: Array<{ name: string; data: number[] }> // one per group (e.g., city)
  stacked?: boolean
  yUnit?: string
}

export type HeatmapChartInput = {
  kind: 'heatmap'
  title?: string
  x: string[] // columns (e.g., products)
  y: string[] // rows (e.g., cities)
  // ECharts wants triples [xIndex, yIndex, value]
  data: Array<[number, number, number]>
}

export type AnyChartInput = LineChartInput | PieChartInput | BarChartInput | HeatmapChartInput
