import type { ChartPlan } from '@/lib/plan'

export type Role = 'user' | 'assistant'

/* Event-log panel */
export type EventLogEntry = {
  eventKind: string
  eventData: Record<string, any>
  conversationId?: string
}

export type EventPart = {
  type: string
  text: string
}

export interface ActionsChart {
  chart_plan: { chart_type: string; chart_data?: ChartPlan; justification?: string }
  source_name: string
  artifacts_id: string
  artifact_index: number
  records_index: number
  records?: Array<any>
}
export interface Actions {
  chart_plans?: ActionsChart[]
  stories?: {
    enable_stories?: boolean
    stories_id?: string
    stories_workspace?: string
    tables?: string[]
    agent_id?: string
    agent_short_example_queries?: string[]
    agent_example_queries?: string[]
  }
}
export interface Artifact {
  name: string
  description: string
  parts: Array<any>
}

export interface MessageAttachment {
  id: string
  document_name: string
  size: number
  type: string // mime type
  uploadStatus?: 'uploaded' | 'ready' | 'failed' // uploaded -> just uploaded, ready -> processed successfully, failed -> processing failed
  guardrailsStatus?: 'passed' | 'content_violation' | 'extraction_failed'
  document_path?: string
  loading?: boolean
}

export interface ToolValidationResponse {
  validationRequestId: string
  validated: boolean
  arguments?: any
}
export interface ToolValidationRequest {
  id: string
  hierarchy: {
    type: string
    agentName?: string
  }[]
  message?: string
  toolName: string
  toolCall: {
    function: {
      name: string
      arguments: string
    }
    id: string
  }
}

export interface Message {
  id?: string
  role: Role
  content: string
  hasEventLog?: boolean
  actions?: Actions
  eventLog?: Array<EventLogEntry>
  filteredEventLog?: Array<EventLogEntry>
  attachments?: MessageAttachment[]
  extractionMode?: string | null
  quotaExceeded?: boolean
  artifactsMetadata?: Record<
    string,
    {
      artifacts: Artifact[]
      artifactsId: string
      agentName: string
      agentId: string
      query: string
      sizeMb: number
      hasRecords: boolean
      preview: boolean
    }
  >
  toolValidationRequests?: Array<ToolValidationRequest>
  toolValidationResponses?: any
}

export interface InitialDraft {
  id: string
  messages: Message[]
  agentIds: string[]
}
