import dataiku


def _prepare_messages(original_messages: list, new_system_prompt: str, new_user_content: str = None):
    """Include original messages to the prompt."""
    history = [m for m in original_messages if m.get("role") != "system"]
    clean_messages = [{"role": "system", "content": new_system_prompt}] + history
    if new_user_content:
        clean_messages.append({"role": "user", "content": new_user_content})
    return clean_messages


def _call_model(model_id: str, messages: list, stream: bool = False):
    """Execute an LLM completion or stream via the DSS Mesh."""
    try:
        project = dataiku.api_client().get_default_project()
        llm_handle = project.get_llm(model_id)

        builder = llm_handle.new_completion()
        for message in messages:
            builder.with_message(message.get("content", message.get("text")), role=message.get("role", "user"))

        if stream:
            return builder.execute_streamed()
        else:
            return builder.execute()
    except Exception as e:
        raise ValueError(f"Member '{model_id}' failed to respond.") from e
