import argparse
import json
import os
import shutil

parser = argparse.ArgumentParser()
parser.add_argument("--symlink", action="store_true")
args = parser.parse_args()

current_dir = os.path.dirname(os.path.realpath(__file__))
default_install_mode = "dev"
plugin_files_to_copy = ["code-env", "python-lib", "resource", "webapps", "plugin.json"]

# Get the DIP_HOME location on the current machine
diphome = os.getenv("DIP_HOME") or input("Enter the DSS installation directory:")
if os.path.isfile(os.path.join(diphome, "install.ini")):
    print(f"'{diphome}' detected as DIP_HOME.")
else:
    print(f"'{diphome}' not a valid DSS installation directory.")
    exit(1)

# Read plugin ID from plugin.json
plugin_json = json.load(open(os.path.join(current_dir, "plugin.json"), "r"))
plugin_id = plugin_json.get("id")
plugin_install_dir = None
assert plugin_id is not None, "Could not find plugin ID in plugin.json"

# Search for existing installation of the plugin
for install_mode in ["installed", "dev"]:
    for plugin_dir in os.listdir(os.path.join(diphome, "plugins", install_mode)):
        if plugin_dir == plugin_id:
            plugin_install_dir = os.path.join(diphome, "plugins", install_mode, plugin_dir)
            print(f"Plugin '{plugin_id}' is already installed in DSS at '{plugin_install_dir}'.")
            break

# Clear existing installation or set default installation path
if plugin_install_dir is None:
    plugin_install_dir = os.path.join(diphome, "plugins", default_install_mode, plugin_id)
else:
    print(f"Deleting existing plugin '{plugin_id}' in '{plugin_install_dir}' ...")
    shutil.rmtree(plugin_install_dir)

print(f"Installing plugin '{plugin_id}' to '{plugin_install_dir}' ...")
os.mkdir(plugin_install_dir)

# Copy plugin files
for file in plugin_files_to_copy:
    src_path = os.path.join(current_dir, file)
    dest_path = os.path.join(plugin_install_dir, file)
    if args.symlink:
        print(f"Symlinking '{src_path}' to '{dest_path}' ...")
        os.symlink(src_path, dest_path)
    else:
        print(f"Copying '{src_path}' to '{dest_path}' ...")
        if os.path.isdir(src_path):
            shutil.copytree(src_path, dest_path, dirs_exist_ok=True)
        else:
            shutil.copy2(src_path, dest_path)
