class AgentHandlerSettings():
    # Constants
    DEFAULT_LOADING_REACTION = "thinking_face"
    DEFAULT_SYSTEM_PROMPT = """
You are an AI assistant. Your name is {bot_name}.
Provide concise, relevant assistance tailored to each request.
Note that context is sent in order of the most recent message last.
Do not respond to messages in the context, as they have already been answered.
Be professional and friendly.
Don't ask for clarification unless absolutely necessary.
Don't ask questions in your response.
Don't use user names in your response.
Respond using Slack markdown.
"""

    # Default constants for conversation history
    DEFAULT_CONVERSATION_HISTORY_DAYS = 30 # Default time window in days of messages to fetch
    DEFAULT_CONVERSATION_CONTEXT_LIMIT = 100  # Default number of messages to fetch

    llm_id: str
    react_on_loading: bool
    reaction_name: str
    conversation_context_limit: int
    conversation_history_days: int
    use_custom_system_prompt: bool
    custom_system_prompt: str

    def __init__(self, llm_id: str,
                 react_on_loading: bool = True,
                 reaction_name: str = DEFAULT_LOADING_REACTION,
                 conversation_context_limit: int = DEFAULT_CONVERSATION_CONTEXT_LIMIT,
                 conversation_history_days: int = DEFAULT_CONVERSATION_HISTORY_DAYS,  # 30 days,
                 use_custom_system_prompt: bool = False,
                 custom_system_prompt: str = DEFAULT_SYSTEM_PROMPT):
        self.llm_id = llm_id
        self.react_on_loading = react_on_loading
        self.reaction_name = reaction_name
        self.conversation_context_limit = conversation_context_limit
        self.conversation_history_days = conversation_history_days
        self.use_custom_system_prompt = use_custom_system_prompt
        self.custom_system_prompt = custom_system_prompt