# Dataiku Agents on Slack plugin

This plugin provides a DSS Visual WebApp to expose a DSS Agent, LLM, RA-LLM, LLM as a bot on Slack.

Socket mode is used so you **do not** need to expose your Dataiku instance.

## Slack bot Visual WebApp

The **Slack bot Integration** webapp enables deploying Dataiku LLMs as Slack bots, responding to messages and mentions.

### Features

- Compatible with any Dataiku DSS LLM Mesh text generation:
  - **Standard LLM**: For general question answering
  - **RAG (Retrieval Augmented Generation)**: With source citation
  - **Agent**: With tool use capabilities

### Configuration

- **Authentication settings**: Set the required secrets
- **LLM Selection**: Choose any LLM configured in your DSS project
- **Logging level**: The logging level you want
- **Conversation settings**: Choose the message limit and time limit to include in a conversation with the model
- **Customize system prompt**: You can choose to add a customized system prompt
- **Loading reaction**: You can choose to have your bot react to messages while it loads its responses

### Usage Notes

- The integration uses threads to maintain conversation context
- The bot responds to:
  - Direct messages
  - Channel mentions (@bot)
  - App Home interactions

**Socket Mode**:
- Creates outbound websocket connections from Dataiku to Slack
- Doesn't require public access to your Dataiku instance
- Simpler to set up
- Requires an App-Level Token with `connections:write` scope

For detailed information about Socket Mode, refer to [Slack's official Socket Mode documentation](https://api.slack.com/apis/socket-mode).

### Setup Steps

Follow these steps to create the Slack integration using the visual webapp after creating your Slack app:

#### 1. Configure Slack App Settings:

Create an app or use an existing one. If you're creating a new one you can do so using the manifest option and specify one with these options:
```json
{
    "display_information": {
        "name": "My agent Slack app",
        "description": "App to interact with a Dataiku Agent through a bot.",
        "background_color": "#1c2a38",
        "long_description": "I'm a bot to interact with a Dataiku Agent. You can talk to me in direct messages or mention me in a channel I'm part of. I will reply in the same thread or start one and consider the thread as part of our conversation."
    },
    "features": {
        "app_home": {
            "home_tab_enabled": true,
            "messages_tab_enabled": false,
            "messages_tab_read_only_enabled": false
        },
        "bot_user": {
            "display_name": "My agent display name",
            "always_online": true
        }
    },
    "oauth_config": {
        "scopes": {
            "bot": [
                "app_mentions:read",
                "channels:history",
                "chat:write",
                "files:read",
                "files:write",
                "im:history",
                "incoming-webhook",
                "mpim:history",
                "reactions:write",
                "users:read"
            ]
        }
    },
    "settings": {
        "event_subscriptions": {
            "bot_events": [
                "app_home_opened",
                "app_mention",
                "message.im"
            ]
        },
        "interactivity": {
            "is_enabled": true
        },
        "org_deploy_enabled": false,
        "socket_mode_enabled": true,
        "token_rotation_enabled": false
    }
}
```

You will however still need to generate an app-level token to enable socket mode.


   - Go to [api.slack.com/apps](https://api.slack.com/apps), find your Slack app for this integration if you're not already on the page
   - In the left sidebar, click "Socket Mode"
   - Toggle "Enable Socket Mode" to ON if not enabled
   - Click "Generate" to create an app-level token
   - Enter a name for the token and add the `connections:write` scope
   - Copy the App-Level Token (starts with `xapp-`)
   - With Socket Mode enabled, you do NOT need to configure the Events API URL or expose your Dataiku instance

> [!IMPORTANT]  
> Each app-level token can only be used by one Dataiku WebApp. Using the same token across multiple webapp instances may cause issues like missing messages, as Slack will randomly distribute events among all active socket connections using that token.

#### 2. Event Subscriptions for the Slack App:
   - In the left sidebar, click "Event Subscriptions"
   - Under "Subscribe to bot events", click "Add Bot User Event" and add the following events:
   
   | Event Name | Description | Required Scope |
   |------------|-------------|---------------|
   | `app_home_opened` | User clicked into your App Home | none |
   | `app_mention` | Subscribe to only the message events that mention your app or bot | `app_mentions:read` |
   | `message.im` | A message was posted in a direct message channel | `im:history` |

   **These event subscriptions are required for your Slack bot to function properly.**

#### 3. Adding Bots to Channels:
   - After installation, your bot will not automatically have access to all channels
   - You must explicitly invite your bot to channels using `/invite @your_bot_name`
   - For private channels, remember that your app needs `groups:history` and `groups:read` permissions
   - Without being added to a channel, your bot won't see messages or be able to respond in that channel

> [!IMPORTANT]  
> If you don't want your bot to be able to read data from private channels **do not** give it the `groups:history` and `groups:read` permissions.

#### 4. Install the Slack App to Workspace:
   - After configuring the bot and permissions, scroll up to "Install App" 
   - Click "(Re)Install to xxx (your Workspace)" to add your app to your Slack workspace
   - Authorize the requested permissions when prompted
   - This is a necessary step to activate your integration
   - Note: This installation is for internal workspace use only

#### 5. Create and Configure the Visual Webapp in Dataiku:
   
   A. **Create the Webapp**:
   - In your Dataiku DSS project, click on "Webapps" in the top navigation
   - Click the "+ New Webapp" button
   - Select "Visual webapp" from the options
   - Find and select "Slack Integration" from the list of webapp types
   - Enter a name for your webapp (e.g., "Slack Assistant")
   - Click "Create" to generate the webapp

   B. **Configure the Integration**:
   - In the webapp settings page, configure the following:
     - **Slack Authentication Settings**:
         - Bot User OAuth Token or User OAuth Token
         - App-Level Token (for Socket Mode)
     - **LLM**: Select the Dataiku LLM to use for generating responses
   - Click "Save" to apply your configurations
   
   C. **Start the Backend**:
   - When you save the webapp, the backend should automatically start
   - You'll see a notification indicating the backend is starting
   - If the backend doesn't start automatically:
     - Go to the "Actions" panel on the right side of the screen
     - Click "Start backend" to manually start it
   
#### 6. **Test the Integration**:
   - In Slack, send a direct message to your bot
   - Or mention the bot in a channel it has joined
   - You should see the bot respond with a message from your configured Agent/LLM

## Dev section

### Setup a local dev environmnent

When developing you most likely just want to run
```bash
make dev
```

It will create the Python virtual environment alonside its dependencies (`setup` target) and open VS Code.

If you only want to create the Python virtual environment run
```bash
make setup
```

This will create a `.venv` folder with the virtual environment for VSCode imports. It contains all the plugin dependencies including the dataiku packages (from the staging instance).

To clear it you can run
```bash
make clean-setup
```

### Build the plugin archive

Run
```bash
make plugin
```

This will create the plugin archive in the dist folder. You can manually upload this archive on a DSS instance.


If instead you want to directly install the plugin on your local instance, specify your `DIP_HOME` and run `make install`:
```bash
DIP_HOME=/Users/myusername/devenv/dss-3/dss-home make install
```

Once installed you need to restart existing WebApps and potentially force refresh your browser webpage for the settings edit page to update.

> [!WARNING]  
> This will overwrite the previously installed plugin. If you've made changes to the plugin on your instance, you will lose them.

### Release

Reach out on the `#rd-plugins-release-pipe` Slack channel.