from typing import Dict, List

import dataiku


def list_groups_with_details() -> Dict[str, List[Dict[str, str]]]:
    """
    Lists all DSS groups and returns them in a format similar to list_projects_with_answers_webapp.

    :return: A dictionary with a "choices" key containing a list of group details.
    """
    groups = dataiku.api_client().list_groups()
    group_choices: List[Dict[str, str]] = []

    for group in groups:
        group_name = group.get('name', 'Unknown')
        is_admin = group.get('admin', False)
        group_label = f"{group_name} (Admin)" if is_admin else group_name

        group_choices.append({
            "value": group_name,  # The group's name to be used as a value
            "label": group_label  # A user-friendly label
        })

    return {"choices": group_choices}

def do(payload, config, plugin_config, inputs):
    parameter_name = payload["parameterName"]

    if parameter_name == "authorized_dss_group":
        return list_groups_with_details() # Not used at the moment
    else:
        return {
            "choices": [
                {
                    "value": "wrong",
                    "label": f"Error getting the name of the parameter.",
                }
            ]
        }