## **AWS Bedrock Agents**

Connect and interact with AWS Bedrock Agents or AWS Bedrock AgentCore Agents directly in Dataiku as a managed agent.

The connected Bedrock Agent or AgentCore Agent is made available as a Dataiku Agent (i.e., a pink diamond in the Dataiku Flow) and
can be leveraged everywhere a Dataiku Agent is available (e.g., in the Flow, or in Chat UIs such as Agent Hub)

## 🚀 Features

* **Streaming Responses**: Supports real-time streaming of agent responses for an interactive user experience.  
* **Knowledge Bank & Tool Support**: Automatically extracts and displays citations from Bedrock Knowledge Banks and information from Action Group (tool) invocations.  

## 📋 Prerequisites

### Dataiku Requirements

* **Dataiku DSS version:** Recommended 14.3.0 or later (token refresh capabilities optimized for 14.4+).  
* **Python Version**: Python 3.9, 3.10, 3.11, 3.12, or 3.13.

### AWS Requirements

* **Bedrock Agent**: An existing agent created and configured in the AWS Bedrock Agent Console or Bedrock AgentCore Console  
* **Agent Credentials**:
    * For a Bedrock Agent: You must have the Bedrock Agent ID and Alias ID.
    * For a Bedrock AgentCore Agent: You must have the AgentCore Agent Runtime ARN
* **IAM Permissions**: The minimum required permission is `bedrock:InvokeAgent` or `bedrock-agentcore-runtime:InvokeAgent`.  

## 📦 Installation

- Follow the Dataiku guide to [install plugins](https://doc.dataiku.com/dss/latest/plugins/installing.html)  

## 🎯 Usage

### 1\. Create a New Agent

* Navigate to your Dataiku project.  
* Go to **Agents & GenAI Models** \> **\+ New Agent**.  
* Select **Bedrock Agent**.

### 2\. Configure the Agent

* **Connection**: Select a S3 or Bedrock connection previously set up in Dataiku
* **AWS Region**: Select the region where your Bedrock agent is deployed (e.g., `us-east-1`, `eu-west-1`).  
* **Mode**: Select between Bedrock Agent and Bedrock AgentCore
   * For Agent **Agent ID & Alias ID**: Enter the specific identifiers for your Bedrock agent.
   * For AgentCore **Runtime ARN**: Enter the ARN of your AgentCoreagent runtime. 

### 3\. Test and Deploy

* Use the built-in chat interface to test your agent  
* Verify responses are streaming correctly

## 🚧 Limitations

* **Human-in-the-Loop (HITL)**: Bedrock Agents that use Action Groups requiring user confirmation (returning control to the user) are not supported. See the AWS Bedrock [documentation](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-returncontrol.html) for more information on tools that return control to the user. 
* **Input Types**: This version supports text-only interactions; image inputs are not yet supported.