def get_aws_credentials(dss_client, connection_name):
    conn_info = dss_client.get_connection(connection_name).get_info()

    if not "params" in conn_info:
        dss_user = dss_client.get_auth_info().get("authIdentifier")

        raise f"Error: Dataiku user '{dss_user}' does not have 'details readable by' permissions on connection " + \
              f"'{connection_name}'.\nCannot authenticate. Please contact your Dataiku administrator for further assistance."

    if conn_info["type"] == "Bedrock":
        s3_conn = conn_info["params"].get("s3Connection", "")
        if not s3_conn:
            raise "Error: The Bedrock connection '%s' is not properly configured. Please specify an S3 connection to use for authentication." % connection_name

        return get_aws_credentials(dss_client, s3_conn)

    if not conn_info["type"] == "EC2":
        raise "Error: The connection '%s' is of type '%s'. Only 'S3 connections are supported here" % (connection_name, conn_info["type"])

    s3_auth_method = conn_info.get("params", {}).get("credentialsMode", "")

    if not s3_auth_method:
        raise "Error: The S3 connection '%s' is not properly configured. Please specify an authentication method." % connection_name

    aws_auth = {}
    aws_auth["aws_access_key_id"] = conn_info.get("resolvedAWSCredential", {}).get("accessKey")
    aws_auth["aws_secret_access_key"] = conn_info.get("resolvedAWSCredential", {}).get("secretKey")
    aws_auth["aws_session_token"] = conn_info.get("resolvedAWSCredential", {}).get("sessionToken")
    credentials_expiration = conn_info.get("resolvedAWSCredential", {}).get("expirationTime", "")

    return aws_auth, credentials_expiration