"""
Dynamic select does for Agent plugins does not seem to work at the moment.
See: https://trello.com/c/Z9L81YP8/11058-ned-martorell-parameter-sets-not-resolved-in-dynamic-select-for-plugin-agents

This code is not currently used, but leaving it for when dynamic select is supported.
"""

import boto3

import dataiku
import aws_bedrock_agents.auth

def do(payload, config, plugin_config, inputs):
    print("DYANMIC SELECT:\n")
    print("payload", payload)
    print("config",config)
    print("plugin_config",plugin_config)
    print("inputs",inputs)
    print()
    
    agent_id = config.get("agent_id", "")
    aws_region = config.get("aws_region", "")
    aws_auth_method = config.get("authentication_method", "")
    s3_connection_name = config.get("s3_connection", "")
    aws_access_key = config.get("aws_access_key", "")
    aws_secret_key = config.get("aws_secret_key", "")
    aws_session_token = config.get("aws_session_token", "")
    
    aws_auth, _, auth_error = aws_bedrock_agents.auth.get_aws_credentials(
        dss_client=dataiku.api_client(),
        aws_auth_method=aws_auth_method,
        connection_name=s3_connection_name,
        aws_access_key=aws_access_key,
        aws_secret_key=aws_secret_key,
        aws_session_token=aws_session_token
    )    
    
    choices = []
    if auth_error:
        choices.append({"value": auth_error, "label": auth_error})
    
    elif payload["parameterName"]=="agent_id":   
        # list agents the credentials have access to
        client=boto3.client(
            service_name="bedrock-agent",
            region_name=config["aws_region"],
            **aws_auth
        )

        try:
            agents = []
            response = client.list_agents(
                maxResults=100,
            )
            agents.extend(response["agentSummaries"])

            while "nextToken" in response:
                response = client.list_agents(
                    maxResults=100,
                    nextToken=response["nextToken"]
                )
                agents.extend(response["agentSummaries"])

            for agent in agents:
                   choices.append({"value": agent["agentId"], "label": agent["agentName"]})       
        except Exception as e:
            choices.append({"value": str(e), "label": str(e)})
    
    elif payload["parameterName"]=="alias_id":
        # list agent aliases
        client=boto3.client(
            service_name="bedrock-agent",
            region_name=config["aws_region"],
            **aws_auth
        )

        try:
            aliases = []
            response = client.list_agent_aliases(
                agentId=agent_id,
                maxResults=100
            )
            aliases.extend(response["agentAliasSummaries"])

            while "nextToken" in response:
                response = client.list_agent_aliases(
                    agentId=agent_id,
                    maxResults=100,
                    nextToken=response["nextToken"]
                )
                aliases.extend(response["agentSummaries"])

            for alias in aliases:
                if alias["aliasInvocationState"]=="ACCEPT_INVOCATIONS":
                    choices.append({"value": alias["agentAliasId"], "label": alias["agentAliasName"]})
        except Exception as e:
            choices.append({"value": str(e), "label": str(e)})

        
    return {"choices": choices}