/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugins.cpr;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.ExposedObject;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.cuspol.CustomPolicyHooks;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SQLNotebooksDAO;
import com.dataiku.dip.dao.StreamingEndpointsDAO;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.plugins.RegularPluginsRegistryService;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.scheduler.ScenariosDAO;
import com.dataiku.dip.scheduler.scenarios.Scenario;
import com.dataiku.dip.scheduler.scenarios.StepBasedScenarioRunner;
import com.dataiku.dip.scheduler.steps.ExecuteSQLStepRunner;
import com.dataiku.dip.scheduler.steps.Step;
import com.dataiku.dip.scheduler.triggers.SQLQueryTriggerRunner;
import com.dataiku.dip.scheduler.triggers.Trigger;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.streaming.endpoints.model.StreamingEndpoint;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class ConnectionsProjectsRestrictionsHooks
extends CustomPolicyHooks {
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private RegularPluginsRegistryService regularPluginsRegistryService;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private UsersDAO usersDAO;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private ManagedFolderDAO managedFoldersDAO;
    @Autowired
    private StreamingEndpointsDAO streamingEndpointsDAO;
    @Autowired
    private SQLNotebooksDAO sqlNotebooksDAO;
    @Autowired
    private ScenariosDAO scenariosDAO;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.plugins.cpr.hooks");

    private boolean isConnectionFreelyUsableByProjectPermissionItem(DSSConnection conn, SerializedProject.PermissionItem pi) throws IOException {
        if (conn.usableBy == DSSConnection.ConnectionUsableBy.ALL) {
            return true;
        }
        if (StringUtils.isNotBlank((String)pi.group)) {
            return conn.allowedGroups.contains(pi.group);
        }
        if (StringUtils.isNotBlank((String)pi.user)) {
            UsersDAO.User u = this.usersDAO.getOrNullUnsafe(pi.user);
            if (u != null) {
                for (String allowedGroup : conn.allowedGroups) {
                    if (!u.groups.contains(allowedGroup)) continue;
                    return true;
                }
                return false;
            }
            logger.warn((Object)("User not found: " + pi.user));
            return true;
        }
        logger.warn((Object)"Invalid permission item: no user nor group");
        return true;
    }

    private boolean isConnectionCompliant(AuthCtx authCtx, SerializedProject sp, JsonObject pluginSettings, String connectionName) throws IOException, DKUSecurityException {
        DSSConnection conn = this.connectionsDAO.getConnection(authCtx, connectionName);
        if (conn == null) {
            logger.info((Object)("Connection " + connectionName + " does not exist, nothing to check"));
            return true;
        }
        Mode mode = Mode.ONLY_IF_FREELY_USABLE_BY_ALL;
        if (pluginSettings.has("restriction_mode")) {
            mode = Mode.valueOf(pluginSettings.get("restriction_mode").getAsString());
        }
        switch (mode) {
            case ONLY_IF_FREELY_USABLE_BY_ALL: {
                for (SerializedProject.PermissionItem pi : sp.permissions) {
                    if (this.isConnectionFreelyUsableByProjectPermissionItem(conn, pi)) continue;
                    logger.info((Object)("Connection " + connectionName + " is not usable by project permission item: " + JSON.json((Object)pi)));
                    return false;
                }
                return true;
            }
            case EXPLICIT_PROJECTS_LIST_PER_CONNECTION: {
                String allowedProp;
                String projectKeyInMessage;
                String projectKeyToCheck;
                Thread currentThread;
                SerializedProject.ProjectAppType projectAppType = sp.projectAppType;
                String generatingAppId = StringUtils.defaultIfEmpty((String)sp.generatingAppId, (String)"");
                if (projectAppType == SerializedProject.ProjectAppType.APP_TEMPLATE && (currentThread = Thread.currentThread()) instanceof SimpleFutureThread && "AppInstantiationFutureThread".equals(currentThread.getClass().getSimpleName())) {
                    try {
                        Field appIdField = currentThread.getClass().getDeclaredField("appId");
                        appIdField.setAccessible(true);
                        generatingAppId = (String)appIdField.get(currentThread);
                        projectAppType = SerializedProject.ProjectAppType.APP_INSTANCE;
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("Unable to check if current project is an app instance because " + t.getMessage()));
                    }
                }
                AppsService.AppOrigin appOrigin = null;
                if (StringUtils.isNotBlank((String)generatingAppId)) {
                    try {
                        appOrigin = AppsService.AppOrigin.fromAppId((String)generatingAppId);
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Unable to find app origin of " + generatingAppId));
                    }
                }
                if (projectAppType == SerializedProject.ProjectAppType.APP_INSTANCE && appOrigin != null) {
                    projectKeyToCheck = appOrigin == AppsService.AppOrigin.PROJECT ? AppsService.getProjectKey((String)generatingAppId) : generatingAppId;
                    projectKeyInMessage = String.format("%s which is an instance of %s ", sp.projectKey, projectKeyToCheck);
                    allowedProp = AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrDefault((List)conn.getDkuProperties(), (String)"dku.security.allowedInApps", (String)"");
                } else {
                    projectKeyToCheck = sp.projectKey;
                    projectKeyInMessage = sp.projectKey;
                    allowedProp = AbstractSQLConnection.CustomDatabaseProperty.getDkuPropertyOrDefault((List)conn.getDkuProperties(), (String)"dku.security.allowedInProjects", (String)"");
                }
                Set allowed = Arrays.stream(allowedProp.split(",")).map(String::trim).filter(s -> !StringUtils.isBlank((String)s)).collect(Collectors.toSet());
                if (allowed.stream().anyMatch(s -> Pattern.matches(s.replace("*", ".*"), projectKeyToCheck))) {
                    return true;
                }
                logger.info((Object)("Connection " + connectionName + " is not allowed for project " + projectKeyInMessage + " (allowed: " + allowedProp + ")"));
                return false;
            }
        }
        throw new Error("unreachable");
    }

    private boolean isDatasetCompliant(AuthCtx authCtx, SerializedProject sp, JsonObject pluginSettings, SerializedDataset sd) throws IOException, DKUSecurityException {
        logger.info((Object)("Checking compliance of dataset " + sd.getFullName() + " in project  " + sp.projectKey));
        Dataset dataset = Dataset.fromSerialized((SerializedDataset)sd);
        HashSet<String> connectionsToCheck = new HashSet<String>();
        String mainConnection = dataset.getParams().getConnection();
        if (mainConnection != null) {
            connectionsToCheck.add(mainConnection);
        }
        if ("UploadedFiles".equals(dataset.getType())) {
            BuiltinFSDatasets.UploadedFilesConfig upCfg = (BuiltinFSDatasets.UploadedFilesConfig)dataset.getParams();
            if (upCfg.uploadConnection != null) {
                connectionsToCheck.add(upCfg.uploadConnection);
            }
        }
        for (String connection : connectionsToCheck) {
            if (this.isConnectionCompliant(authCtx, sp, pluginSettings, connection)) continue;
            logger.info((Object)("Dataset " + sd.name + " is not compliant because connection " + connection + " is not"));
            return false;
        }
        return true;
    }

    private boolean isManagedFolderCompliant(AuthCtx authCtx, SerializedProject sp, JsonObject pluginSettings, ManagedFolder mf) throws IOException, DKUSecurityException {
        if (mf.getParams().connection != null && !this.isConnectionCompliant(authCtx, sp, pluginSettings, mf.getParams().connection)) {
            logger.info((Object)("Managed Folder " + mf.id + " is not compliant because connection " + mf.getParams().connection + " is not"));
            return false;
        }
        return true;
    }

    private boolean isStreamingEndpointCompliant(AuthCtx authCtx, SerializedProject sp, JsonObject pluginSettings, StreamingEndpoint se) throws IOException, DKUSecurityException {
        if (se.getParams().getConnection() != null && !this.isConnectionCompliant(authCtx, sp, pluginSettings, se.getParams().getConnection())) {
            logger.info((Object)("Managed Folder " + se.id + " is not compliant because connection " + se.getParams().getConnection() + " is not"));
            return false;
        }
        return true;
    }

    private boolean isSQLNotebookCompliant(AuthCtx authCtx, SerializedProject sp, JsonObject pluginSettings, SQLNotebook notebook) throws IOException, DKUSecurityException {
        if (!this.isConnectionCompliant(authCtx, sp, pluginSettings, notebook.connection)) {
            logger.info((Object)("SQL Notebook " + notebook.id + " is not compliant because connection " + notebook.connection + " is not"));
            return false;
        }
        return true;
    }

    private boolean isScenarioCompliant(AuthCtx authCtx, SerializedProject sp, JsonObject pluginSettings, Scenario scenario) throws IOException, DKUSecurityException {
        for (Trigger trigger : scenario.getTriggers()) {
            if (!SQLQueryTriggerRunner.META.getType().equals(trigger.getType())) continue;
            SQLQueryTriggerRunner.SQLQueryTriggerParams sqtp = (SQLQueryTriggerRunner.SQLQueryTriggerParams)trigger.getParamsAs(SQLQueryTriggerRunner.SQLQueryTriggerParams.class);
            if (this.isConnectionCompliant(authCtx, sp, pluginSettings, sqtp.connection)) continue;
            logger.info((Object)("Scenario " + scenario.name + " is not compliant because connection " + sqtp.connection + " is not"));
            return false;
        }
        if (scenario.getParams() instanceof StepBasedScenarioRunner.StepBasedScenarioParams) {
            StepBasedScenarioRunner.StepBasedScenarioParams sbsp = (StepBasedScenarioRunner.StepBasedScenarioParams)scenario.getParamsAs(StepBasedScenarioRunner.StepBasedScenarioParams.class);
            for (Step step : sbsp.steps) {
                if (!ExecuteSQLStepRunner.META.getType().equals(step.getType())) continue;
                ExecuteSQLStepRunner.ExecuteSQLStepParams essp = (ExecuteSQLStepRunner.ExecuteSQLStepParams)step.getParamsAs(ExecuteSQLStepRunner.ExecuteSQLStepParams.class);
                if (this.isConnectionCompliant(authCtx, sp, pluginSettings, essp.connection)) continue;
                logger.info((Object)("Scenario " + scenario.name + " is not compliant because connection " + essp.connection + " is not"));
                return false;
            }
        }
        return true;
    }

    private void checkComplianceOfEachExposedObject(AuthCtx authCtx, SerializedProject sourceProject, JsonObject pluginSettings) throws Exception {
        if (sourceProject.exposedObjects == null) {
            return;
        }
        for (ExposedObject eo : sourceProject.exposedObjects.objects) {
            for (ExposedObject.Rule rule : eo.rules) {
                SerializedProject targetProject;
                if (!StringUtils.isNotBlank((String)rule.targetProject) || (targetProject = this.projectsService.getOrNullUnsafe(rule.targetProject)) == null) continue;
                switch (eo.type) {
                    case DATASET: {
                        SerializedDataset sd = (SerializedDataset)this.datasetsDAO.getOrNull(sourceProject.projectKey, eo.localName);
                        if (sd == null || this.isDatasetCompliant(authCtx, targetProject, pluginSettings, sd)) break;
                        throw new Exception("Save denied: project " + sourceProject.projectKey + " shares dataset " + eo.localName + " to project " + rule.targetProject + ", but this target project may not use the connection of this dataset");
                    }
                    case MANAGED_FOLDER: {
                        ManagedFolder mf = (ManagedFolder)this.managedFoldersDAO.getOrNull(sourceProject.projectKey, eo.localName);
                        if (mf == null || this.isManagedFolderCompliant(authCtx, targetProject, pluginSettings, mf)) break;
                        throw new Exception("Save denied: project " + sourceProject.projectKey + " shares folder " + eo.localName + " to project " + rule.targetProject + ", but this target project may not use the connection of this dataset");
                    }
                    case STREAMING_ENDPOINT: {
                        StreamingEndpoint se = (StreamingEndpoint)this.streamingEndpointsDAO.getOrNull(sourceProject.projectKey, eo.localName);
                        if (se == null || this.isStreamingEndpointCompliant(authCtx, targetProject, pluginSettings, se)) break;
                        throw new Exception("Save denied: project " + sourceProject.projectKey + " shares streaming endpoint  " + eo.localName + " to project " + rule.targetProject + ", but this target project may not use the connection of this dataset");
                    }
                    case SQL_NOTEBOOK: {
                        break;
                    }
                    case SCENARIO: {
                        break;
                    }
                }
            }
        }
    }

    public void onPreDatasetCreation(AuthCtx authCtx, SerializedDataset serializedDataset, DatasetSaveService.DatasetCreationContext context) throws Exception {
        boolean enabled;
        JsonObject pluginSettings = this.regularPluginsRegistryService.getSettings((String)"connections-projects-restrictions").config;
        if (pluginSettings.has("enabled") && !(enabled = pluginSettings.get("enabled").getAsBoolean())) {
            logger.debug((Object)"CPR plugin disabled, not checking anything");
            return;
        }
        SerializedProject sp = this.projectsService.getMandatory(serializedDataset.getProjectKey());
        if (!this.isDatasetCompliant(authCtx, sp, pluginSettings, serializedDataset)) {
            throw new Exception("Cannot create this dataset: it uses connections that are forbidden in this project");
        }
    }

    public void onPreObjectSave(AuthCtx authCtx, TaggableObjectsService.TaggableObject before, TaggableObjectsService.TaggableObject after) throws Exception {
        SerializedProject sp;
        boolean enabled;
        JsonObject pluginSettings = this.regularPluginsRegistryService.getSettings((String)"connections-projects-restrictions").config;
        if (pluginSettings.has("enabled") && !(enabled = pluginSettings.get("enabled").getAsBoolean())) {
            logger.debug((Object)"CPR plugin disabled, not checking anything");
            return;
        }
        logger.info((Object)("onPreObjectSave: " + after.getTaggableType() + ": " + after.getFullId()));
        if (after instanceof SerializedProject) {
            SerializedProject afterProject = (SerializedProject)after;
            for (SerializedDataset sd : this.datasetsDAO.listUnsafe(afterProject.projectKey)) {
                if (this.isDatasetCompliant(authCtx, afterProject, pluginSettings, sd)) continue;
                throw new Exception("Save denied: project " + afterProject.projectKey + " contains dataset " + sd.name + " which is not allowed in this project according to strict connection rules");
            }
            for (ManagedFolder mf : this.managedFoldersDAO.listUnsafe(afterProject.projectKey)) {
                if (this.isManagedFolderCompliant(authCtx, afterProject, pluginSettings, mf)) continue;
                throw new Exception("Save denied: project " + afterProject.projectKey + " contains managed folder " + mf.id + " which is not allowed in this project according to strict connection rules");
            }
            for (StreamingEndpoint se : this.streamingEndpointsDAO.listUnsafe(afterProject.projectKey)) {
                if (this.isStreamingEndpointCompliant(authCtx, afterProject, pluginSettings, se)) continue;
                throw new Exception("Save denied: project " + afterProject.projectKey + " contains streaming endpoint" + se.id + " which is not allowed in this project according to strict connection rules");
            }
            for (Scenario s : this.scenariosDAO.listUnsafe(afterProject.projectKey)) {
                if (this.isScenarioCompliant(authCtx, afterProject, pluginSettings, s)) continue;
                throw new Exception("Save denied: project " + afterProject.projectKey + " contains scenario " + s.id + " which is not allowed in this project according to strict connection rules");
            }
            for (SQLNotebook sn : this.sqlNotebooksDAO.listUnsafe(afterProject.projectKey)) {
                if (this.isSQLNotebookCompliant(authCtx, afterProject, pluginSettings, sn)) continue;
                throw new Exception("Save denied: project " + afterProject.projectKey + " contains SQL notebook " + sn.id + " which is not allowed in this project according to strict connection rules");
            }
            this.checkComplianceOfEachExposedObject(authCtx, afterProject, pluginSettings);
        } else if (after instanceof SerializedDataset) {
            SerializedProject sp2 = this.projectsService.getMandatoryUnsafe(after.getProjectKey());
            if (!this.isDatasetCompliant(authCtx, sp2, pluginSettings, (SerializedDataset)after)) {
                throw new Exception("Save denied: project " + after.getProjectKey() + " contains dataset " + after.getId() + " which is not allowed in this project according to strict connection rules");
            }
        } else if (after instanceof ManagedFolder) {
            SerializedProject sp3 = this.projectsService.getMandatoryUnsafe(after.getProjectKey());
            if (!this.isManagedFolderCompliant(authCtx, sp3, pluginSettings, (ManagedFolder)after)) {
                throw new Exception("Save denied: project " + after.getProjectKey() + " contains managed folder " + after.getId() + " which is not allowed in this project according to strict connection rules");
            }
        } else if (after instanceof StreamingEndpoint) {
            SerializedProject sp4 = this.projectsService.getMandatoryUnsafe(after.getProjectKey());
            if (!this.isStreamingEndpointCompliant(authCtx, sp4, pluginSettings, (StreamingEndpoint)after)) {
                throw new Exception("Save denied: project " + after.getProjectKey() + " contains streaming endpoint " + after.getId() + " which is not allowed in this project according to strict connection rules");
            }
        } else if (after instanceof Scenario) {
            SerializedProject sp5 = this.projectsService.getMandatoryUnsafe(after.getProjectKey());
            if (!this.isScenarioCompliant(authCtx, sp5, pluginSettings, (Scenario)after)) {
                throw new Exception("Save denied: project " + after.getProjectKey() + " contains scenario " + after.getId() + " which is not allowed in this project according to strict connection rules");
            }
        } else if (after instanceof SQLNotebook && !this.isSQLNotebookCompliant(authCtx, sp = this.projectsService.getMandatoryUnsafe(after.getProjectKey()), pluginSettings, (SQLNotebook)after)) {
            throw new Exception("Save denied: project " + after.getProjectKey() + " contains SQL Notebook " + after.getId() + " which is not allowed in this project according to strict connection rules");
        }
    }

    public void onPreSQLConnectionDirectUse(AuthCtx user, String contextProjectKey, String connectionName) throws Exception {
        boolean enabled;
        JsonObject pluginSettings = this.regularPluginsRegistryService.getSettings((String)"connections-projects-restrictions").config;
        if (pluginSettings.has("enabled") && !(enabled = pluginSettings.get("enabled").getAsBoolean())) {
            logger.debug((Object)"CPR plugin disabled, not checking anything");
            return;
        }
        if (StringUtils.isBlank((String)contextProjectKey)) {
            return;
        }
        SerializedProject sp = this.projectsService.getMandatoryUnsafe(contextProjectKey);
        if (!this.isConnectionCompliant(user, sp, pluginSettings, connectionName)) {
            throw new Exception("SQL usage denied, connection " + connectionName + "\u00a0is not allowed in this project according to strict connection rules");
        }
    }

    static enum Mode {
        ONLY_IF_FREELY_USABLE_BY_ALL,
        EXPLICIT_PROJECTS_LIST_PER_CONNECTION;

    }
}

