# OpenCode for Code Studio

This Dataiku DSS plugin integrates the OpenCode coding assistant into the IDEs within Code Studios.

## Overview

This plugin brings the generative AI capabilities of OpenCode directly into your Code Studio environment. It is designed to assist developers by integrating a coding assistant into their workflow.

## Features

*   **Powered by Dataiku's LLM Mesh**: Leverages the central LLM gateway for enhanced security and scalability.
*   **Full OpenCode Functionality**: Provides access to the complete feature set of OpenCode.
*   **VS Code Integration**: Connects to Visual Studio Code through a companion extension, allowing for a seamless development experience.

## Prerequisites

*   **VS Code Companion Extension**: If you intend to use the companion extension for Visual Studio Code, the `VSCode` block must be placed before the `OpenCode` block in your Code Studio template. Failure to do so will result in a failed installation of the extension.
*   **Dataiku LLM Mesh Connection**: An administrator must configure a connection to a Large Language Model through the Dataiku LLM Mesh. This is the only supported method for providing credentials.
*   **Public Internet Access**: The Code Studio instance must have access to the public internet. Private clusters are not supported.

## Usage

There are two primary ways to interact with OpenCode within your Code Studio environment:

*   **From the Terminal**: You can run `opencode` commands directly from any terminal in your Code Studio instance. The CLI can be used non-interactively for single commands, or with the terminal user interface (TUI) for an interactive session.
*   **Using the VS Code Companion Extension**: For a more integrated experience, you can use the companion extension for Visual Studio Code. This allows you to interact with OpenCode directly from your editor.

## Configuration

The OpenCode plugin is designed to seamlessly integrate with Dataiku's LLM Mesh. An administrator must configure the plugin to use an existing LLM connection from Dataiku DSS. This is the only supported configuration and is the recommended approach for centralized and secure API key management.

Administrators can filter which LLM models are propagated into the Code Studio instance, allowing for granular control over the available models.

The plugin automatically applies `context window` and `max output tokens` values for all propagated models (data sourced from `models.dev`). These default values can be overridden in the plugin's settings to fine-tune model performance.

## License

This plugin is licensed under the Apache Software License.

---

Copyright © 2025 Dataiku