from flask import Blueprint

from .ask import ask_bp
from .config import config_blueprint
from .conversations import conversations_blueprint
from .feedback import general_feedback_blueprint
from .file import file_blueprint
from .logging import logging_blueprint

api = Blueprint("api", __name__, url_prefix="/api")
api.register_blueprint(file_blueprint)
api.register_blueprint(logging_blueprint)
api.register_blueprint(conversations_blueprint)
api.register_blueprint(config_blueprint)
api.register_blueprint(general_feedback_blueprint)
api.register_blueprint(ask_bp)
