
from typing import List

from answers.solutions.vector_search.generic_vector_search import (
    GenericVectorQuery,
    NumericConditional,
    ValueConditional,
)
from answers.solutions.vector_search.models import VecOperator

# TODO: Needs testing <<<<<<<<<<<<<<<<<<<<<<<<<<<
##################################################
# Caution Azure AI Search users filters not filter
##################################################


class AzureAiOperator(VecOperator):
    pass

class AzureAiSearchQuery(GenericVectorQuery):
    def __init__(self):
        super().__init__(AzureAiOperator)

    @property
    def supports_hybrid(self):
        return True

    @property
    def hybrid_key(self) -> str:
        return "search"
        
    def eq_cond(self, field: str, value: ValueConditional) -> str:
        if isinstance(value, List):
            raise ValueError("Value must be a single value for EQ operator")
        return f"{field} eq '{value}' "

    def ne_cond(self, field: str, value: ValueConditional) -> str:
        if isinstance(value, list):
            raise ValueError("Value must be a single value for NE operator")
        return f"{field} ne '{value}' "

    def gt_cond(self, field: str, value: NumericConditional) -> str:
        if isinstance(value, list) or isinstance(value, str):
            raise ValueError("Value must be a single numerical value for GT operator")
        return f"{field} gt {value} "

    def gte_cond(self, field: str, value: NumericConditional) -> str:
        raise NotImplementedError("GTE operator is not supported by Azure AI Search")
    
    def lt_cond(self, field: str, value: NumericConditional) -> str:
        if isinstance(value, list) or isinstance(value, str):
            raise ValueError("Value must be a single numerical value for LT operator")
        return f"{field} lt {value} "
    
    def lte_cond(self, field: str, value: NumericConditional) -> str:
        raise NotImplementedError("LTE operator is not supported by Azure AI Search")
    
    def in_cond(self, field, values) -> str:
        if not isinstance(values, list):
            raise ValueError("Values must be a list for IN operator")
        return f"search.in({field}, '{','.join(values)}') "

    def nin_cond(self, field, values) -> str:
        if not isinstance(values, list):
            raise ValueError("Values must be a list for NIN operator")
        return f"not search.in({field}, '{','.join(values)}') "

    ##################################################
    # Caution Azure AI Search users filters not filter
    ##################################################
    def or_op(self, expression_list, key: str = "filters") -> None:
        self.verify_filter_key(key)
        self._query[key].update(" or ".join([f"({expression})" for expression in expression_list]))

    def and_op(self, expression_list, key: str = "filters") -> None:
        self.verify_filter_key(key)
        self._query[key].update(" and ".join([f"({expression})" for expression in expression_list]))
    ##################################################

    def parse_expression(self, _: str, value: str) -> str:
        return value