from functools import lru_cache
from typing import Any, Dict, Optional

from common.backend.utils.dataiku_api import dataiku_api


def find_recipe(graph_data: Dict[str, Any], successor_id: str):
    """
    Finds the node of a given successor in a flow graph JSON data structure.

    :param graph_json: A JSON graph object
    :param successor: The successor for which to find the node.
    :return: The node
    """
    nodes = graph_data.get("nodes", {})

    for node_name, node in nodes.items():
        if successor_id in node.get("successors", []):
            return node

    raise KeyError(successor_id)


@lru_cache(maxsize=None)
def get_llm_friendly_name(id: Optional[str]) -> Any:
    if id is None:
        return None
    project = dataiku_api.default_project
    for llm in project.list_llms():
        if llm.get('id') == id:
            return llm.get('friendlyName', id)
    return None


