from datetime import datetime


def from_datetime_to_dss_string_date(datetime: datetime) -> str:
    """
    Converts a datetime object into a dataiku DSS string datetime value.

    :param: datetime:  datetime.datetime: The datetime date to convert.

    :returns: dss_string_date: str: DSS string date associated with the 'datetime_date'.
    """
    # We remove the end of the string to get 'milliseconds' resolution instead of 'microseconds'.
    datetime_info = datetime.strftime("%Y-%m-%dT%H:%M:%S.%f")[:-3]
    timezone_info = datetime.strftime("%z")
    dss_string_date = datetime_info + timezone_info
    return dss_string_date
