import { SUPPORTED_CUSTOM_IMAGES_EXTENSIONS, CUSTOMIZATION_PATH } from './constants'
import { useNotification } from './useNotification'
export function inIframe() {
  try {
    return window.self !== window.top
  } catch (e) {
    return true
  }
}

export function createNotification(type: 'positive' | 'negative', msg: string) {
  const { createNotification } = useNotification()

  createNotification(type, msg)

}
export function getCustomImagePath(
  fileName: string,
  defaultFileName: string,
  theme?: string,
  imgError?: boolean
) {
  if (imgError) {
    return defaultFileName
  }
  const customFileExtension = fileName.split('.').pop()
  if (
    !theme ||
    !customFileExtension ||
    !SUPPORTED_CUSTOM_IMAGES_EXTENSIONS.includes(customFileExtension)
  ) {
    return defaultFileName
  }
  return `${CUSTOMIZATION_PATH}/${theme}/images/${fileName}`
}

export function stringToEnum<T extends Record<string, string>>(
  enumObj: T,
  value: string
): T[keyof T] | undefined {
  return Object.values(enumObj).includes(value as T[keyof T]) ? (value as T[keyof T]) : undefined
}

export const updateNestedObject = (obj: any, keys: string[], value: string | number | null) => {
  if (keys.length === 1) {
    obj[keys[0]].value = value ?? ''
    return
  }

  const key = keys.shift()
  if (key === undefined) return
  updateNestedObject(obj[key], keys, value)
}

export const updateObject = (myObject:any, key: string, value: string | number | null) => {
  const keys = key.split('.')
  const newObject = JSON.parse(JSON.stringify(myObject))
  if (keys.length > 1) {
    updateNestedObject(newObject, keys, value)
  } else {
    newObject[key].value = value ?? ''
  }
  return newObject
}
